/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.Device;
import ibm.nways.jdm.JdmDevice;
import ibm.nways.jdm.NMPlatformDBInterface;
import ibm.nways.jdm.OvObjectListHandlerInterface;
import ibm.nways.jdm.OvObjectListListenerInterface;
import ibm.nways.jdm.OvRemoteListListenerInterface;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

public class OvObjectListHandlerClient
implements OvRemoteListListenerInterface,
Serializable {
    public static final int DEFAULT_PORT = 2099;
    private OvObjectListHandlerInterface platformListHandler;
    private NMPlatformDBInterface platformdb;
    private boolean initialized = false;
    private boolean registeredForUpdates = false;
    private OvObjectListListenerInterface updatesListener;

    public boolean init(String string) {
        Object object;
        System.out.println("OvObjectListHandlerClient.init: exporting remote object");
        try {
            UnicastRemoteObject.exportObject(this);
        }
        catch (RemoteException remoteException) {
            System.out.println("OvObjectListHandlerClient exportObjectException, list updation won't work");
            remoteException.printStackTrace();
        }
        Integer n = new Integer(2099);
        try {
            object = n.toString();
            System.out.println("@@@@OvObjectListHandler Client Port number: " + (String)object);
            if (string == null) {
                string = InetAddress.getLocalHost().getHostName();
            }
            this.platformListHandler = (OvObjectListHandlerInterface)Naming.lookup("//" + string + ":" + (String)object + "/OvObjectListHandler");
            System.out.println("@@@@OvObjectListHandler version: " + this.platformListHandler.getVersion());
        }
        catch (Exception exception) {
            System.out.println("@@@@OvObjectListHandlerClient RMI exception using host " + string);
            exception.printStackTrace();
            return false;
        }
        object = new Integer(2099);
        try {
            String string2 = ((Integer)object).toString();
            System.out.println("@@@@NMPlatformDBHandler Client Port number: " + string2);
            if (string == null) {
                string = InetAddress.getLocalHost().getHostName();
            }
            this.platformdb = (NMPlatformDBInterface)Naming.lookup("//" + string + ":" + string2 + "/NMPlatformDB");
            System.out.println("@@@@NMPlatformDBHandler version: " + this.platformdb.getVersion());
        }
        catch (Exception exception) {
            System.out.println("@@@@OvObjectListHandlerClient RMI exception for platform db:");
            exception.printStackTrace();
            return false;
        }
        this.initialized = true;
        return this.initialized;
    }

    public synchronized Vector getDbObjectList() {
        if (!this.initialized) {
            this.init(null);
        }
        Vector vector = null;
        try {
            vector = this.platformListHandler.getDbObjectList();
            if (vector != null) {
                int n = 0;
                int n2 = vector.size();
                while (n < n2) {
                    ((JdmDevice)vector.elementAt(n)).setPlatformDBServer(this.platformdb);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("platformListHandler DB AccessException:");
            exception.printStackTrace();
        }
        return vector;
    }

    public void startObjectList() {
        if (!this.initialized) {
            this.init(null);
        }
        try {
            this.platformListHandler.startObjectList();
            return;
        }
        catch (Exception exception) {
            System.out.println("platformListHandler DB AccessException:");
            exception.printStackTrace();
            return;
        }
    }

    public void stopObjectList() {
        if (!this.initialized) {
            this.init(null);
        }
        try {
            this.platformListHandler.stopObjectList();
            return;
        }
        catch (Exception exception) {
            System.out.println("platformListHandler DB AccessException:");
            exception.printStackTrace();
            return;
        }
    }

    public boolean registerForOvListUpdates(OvObjectListListenerInterface ovObjectListListenerInterface) {
        if (!this.initialized) {
            this.init(null);
        }
        System.out.println("platformListHandler::registerForOvListUpdates!");
        boolean bl = false;
        try {
            if (ovObjectListListenerInterface != null) {
                System.out.println("^platformListHandler::registerForOvListUpdates reging with server!");
                bl = this.platformListHandler.registerForOvListUpdates(this);
                System.out.println("^platformListHandler::registerForOvListUpdates reg with server SUCCESS!");
                this.updatesListener = ovObjectListListenerInterface;
                this.registeredForUpdates = true;
            } else {
                System.out.println("platformListHandler::registerForOvListUpdates Null reference for listener!");
            }
        }
        catch (Exception exception) {
            System.out.println("platformListHandler DB AccessException:");
            exception.printStackTrace();
        }
        return bl;
    }

    public boolean deregisterForOvListUpdates(OvObjectListListenerInterface ovObjectListListenerInterface) {
        if (!this.initialized) {
            this.init(null);
        }
        boolean bl = false;
        try {
            if (this.registeredForUpdates && this.updatesListener == ovObjectListListenerInterface) {
                bl = this.platformListHandler.deregisterForOvListUpdates(this);
                this.updatesListener = null;
                this.registeredForUpdates = false;
            } else {
                System.out.println("platformListHandler::deregisterForOvListUpdates incorrect reference passed!" + ovObjectListListenerInterface);
            }
        }
        catch (Exception exception) {
            System.out.println("platformListHandler DB AccessException:");
            exception.printStackTrace();
        }
        return bl;
    }

    public Device getDeviceByName(String string) {
        if (!this.initialized) {
            this.init(null);
        }
        Device device = null;
        try {
            device = this.platformListHandler.getDeviceByName(string);
            ((JdmDevice)device).setPlatformDBServer(this.platformdb);
        }
        catch (Exception exception) {
            System.out.println("platformListHandler DB AccessException:");
            exception.printStackTrace();
        }
        return device;
    }

    public Device getDeviceByAddr(int n, Object object) {
        if (!this.initialized) {
            this.init(null);
        }
        Device device = null;
        try {
            device = this.platformListHandler.getDeviceByAddr(n, object);
            ((JdmDevice)device).setPlatformDBServer(this.platformdb);
        }
        catch (Exception exception) {
            System.out.println("platformListHandler DB AccessException:");
            exception.printStackTrace();
        }
        return device;
    }

    public Device getDeviceByKey(String string) {
        if (!this.initialized) {
            this.init(null);
        }
        Device device = null;
        try {
            device = this.platformListHandler.getDeviceByKey(string);
            ((JdmDevice)device).setPlatformDBServer(this.platformdb);
        }
        catch (Exception exception) {
            System.out.println("platformListHandler DB AccessException:");
            exception.printStackTrace();
        }
        return device;
    }

    public Vector getDeviceByType(Object object) {
        if (!this.initialized) {
            this.init(null);
        }
        Vector vector = null;
        try {
            vector = this.platformListHandler.getDeviceByType(object);
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                ((JdmDevice)vector.elementAt(n)).setPlatformDBServer(this.platformdb);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("platformListHandler DB AccessException:");
            exception.printStackTrace();
        }
        return vector;
    }

    public Vector getAllDevices() {
        if (!this.initialized) {
            this.init(null);
        }
        Vector vector = null;
        try {
            vector = this.platformListHandler.getAllDevices();
            int n = 0;
            int n2 = vector.size();
            while (n < n2) {
                ((JdmDevice)vector.elementAt(n)).setPlatformDBServer(this.platformdb);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("platformListHandler DB AccessException:");
            exception.printStackTrace();
        }
        return vector;
    }

    public void addDevice(Device device) {
        if (!this.initialized) {
            this.init(null);
        }
        try {
            this.platformListHandler.addDevice(device);
            return;
        }
        catch (Exception exception) {
            System.out.println("platformListHandler DB AccessException:");
            exception.printStackTrace();
            return;
        }
    }

    public boolean ovListReady() {
        if (this.registeredForUpdates) {
            this.updatesListener.ovListReady();
        }
        return true;
    }

    public boolean ovObjectAdded(JdmDevice jdmDevice) {
        if (this.registeredForUpdates) {
            this.updatesListener.ovObjectAdded(jdmDevice);
        }
        return true;
    }

    public boolean ovObjectDeleted(JdmDevice jdmDevice) {
        if (this.registeredForUpdates) {
            this.updatesListener.ovObjectDeleted(jdmDevice);
        }
        return true;
    }
}

